import React from 'react';
import { useToast } from '../context/ToastContext';

const Toast: React.FC = () => {
  const { toastMessage, isToastVisible } = useToast();

  return (
    <div
      aria-live="assertive"
      className={`fixed inset-0 flex items-end justify-center px-4 py-6 pointer-events-none sm:p-6 z-[100]`}
    >
      <div
        className={`
          transition-all duration-500 ease-in-out
          ${isToastVisible ? 'transform-none opacity-100' : 'translate-y-20 opacity-0'}
          max-w-sm w-full bg-on-surface text-surface rounded-lg shadow-lg pointer-events-auto
        `}
      >
        <div className="p-4">
          <div className="flex items-center">
            <div className="flex-shrink-0">
              <svg className="w-6 h-6 text-green-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" strokeWidth="1.5" stroke="currentColor">
                <path strokeLinecap="round" strokeLinejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
              </svg>
            </div>
            <div className="ml-3 w-0 flex-1">
              <p className="text-sm font-medium">{toastMessage}</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default Toast;
