
export interface Transaction {
    id: string;
    date: string; // YYYY-MM-DD
    description: string;
    amount: number;
    categoryId: string;
    type: 'income' | 'expense';
    walletId: string;
    transferId?: string; // To link two transfer transactions
    debtId?: string;
    isShareBill?: boolean;
    shareBillDone?: boolean;
    isShareBillRepayment?: boolean;
    linkedShareBillTxId?: string;
    excludeFromReport?: boolean;
    image?: string; // Base64 string of the attached image
}

export interface Debt {
    id: string;
    type: 'loan' | 'debt'; 
    person: string;
    description: string;
    initialAmount: number;
    outstandingAmount: number;
    creationDate: string; 
    dueDate?: string; 
    status: 'open' | 'paid';
}

export interface Category {
    id: string;
    name: string;
    parentId?: string | null;
    icon: string; 
    color: string; 
    order: number;
}

export interface Wallet {
    id:string;
    name: string;
    initialBalance: number;
    type: 'cash' | 'bank' | 'credit' | 'crypto';
    creditLimit?: number;
    parentWalletId?: string | null;
    order: number;
    showOnDashboard?: boolean;
}

export interface LanguageContent {
    [key: string]: string | { [key: string]: string };
}
