
import { Category, Wallet } from './types';

export const DEFAULT_CATEGORIES: Category[] = [
    // Expenses
    { id: 'cat-e1', name: 'Ăn uống', parentId: null, icon: 'BeakerIcon', color: '#ef4444', order: 0 },
    { id: 'cat-e2', name: 'Tạp hóa', parentId: 'cat-e1', icon: 'ShoppingCartIcon', color: '#f97316', order: 0 },
    { id: 'cat-e3', name: 'Nhà hàng', parentId: 'cat-e1', icon: 'FireIcon', color: '#eab308', order: 1 },
    { id: 'cat-e4', name: 'Quán cà phê', parentId: 'cat-e1', icon: 'CafeIcon', color: '#84cc16', order: 2 },
    
    { id: 'cat-e5', name: 'Di chuyển', parentId: null, icon: 'CarIcon', color: '#22c55e', order: 1 },
    { id: 'cat-e6', name: 'Xăng xe', parentId: 'cat-e5', icon: 'FuelIcon', color: '#10b981', order: 0 },
    { id: 'cat-e7', name: 'Giao thông công cộng', parentId: 'cat-e5', icon: 'BusIcon', color: '#14b8a6', order: 1 },

    { id: 'cat-e8', name: 'Mua sắm', parentId: null, icon: 'ShoppingBagIcon', color: '#06b6d4', order: 2 },
    { id: 'cat-e9', name: 'Quần áo', parentId: 'cat-e8', icon: 'TShirtIcon', color: '#0ea5e9', order: 0 },
    { id: 'cat-e10', name: 'Đồ điện tử', parentId: 'cat-e8', icon: 'DevicePhoneMobileIcon', color: '#3b82f6', order: 1 },

    { id: 'cat-e11', name: 'Nhà ở', parentId: null, icon: 'HomeModernIcon', color: '#6366f1', order: 3 },
    { id: 'cat-e12', name: 'Tiền thuê nhà', parentId: 'cat-e11', icon: 'KeyIcon', color: '#8b5cf6', order: 0 },
    { id: 'cat-e13', name: 'Tiện ích', parentId: 'cat-e11', icon: 'WrenchScrewdriverIcon', color: '#a855f7', order: 1 },
    { id: 'cat-e13a', name: 'Tiền điện', parentId: 'cat-e13', icon: 'FireIcon', color: '#facc15', order: 0 },
    { id: 'cat-e13b', name: 'Tiền nước', parentId: 'cat-e13', icon: 'BeakerIcon', color: '#38bdf8', order: 1 },

    { id: 'cat-e14', name: 'Giải trí', parentId: null, icon: 'FilmIcon', color: '#d946ef', order: 4 },
    { id: 'cat-e15', name: 'Sức khỏe', parentId: null, icon: 'HeartIcon', color: '#ec4899', order: 5 },
    { id: 'cat-e16', name: 'Giáo dục', parentId: null, icon: 'AcademicCapIcon', color: '#f43f5e', order: 6 },
    { id: 'cat-e17', name: 'Chi phí khác', parentId: null, icon: 'SparklesIcon', color: '#78716c', order: 7 },

    // Incomes
    { id: 'cat-i1', name: 'Thu nhập', parentId: null, icon: 'BanknotesIcon', color: '#16a34a', order: 8 },
    { id: 'cat-i2', name: 'Lương', parentId: 'cat-i1', icon: 'BriefcaseIcon', color: '#2563eb', order: 0 },
    { id: 'cat-i3', name: 'Đầu tư', parentId: 'cat-i1', icon: 'ChartBarIcon', color: '#ca8a04', order: 1 },
    { id: 'cat-i4', name: 'Thu nhập khác', parentId: 'cat-i1', icon: 'GiftIcon', color: '#c026d3', order: 2 },

    // System Categories
    { id: 'cat-transfer', name: 'Chuyển tiền', parentId: null, icon: 'ArrowsRightLeftIcon', color: '#64748b', order: 998 },
    { id: 'cat-debt', name: 'Thanh toán Nợ', parentId: null, icon: 'BookOpenIcon', color: '#4b5563', order: 999 },
];


export const DEFAULT_WALLETS: Wallet[] = [
    { id: 'wallet-1', name: 'Tiền mặt', initialBalance: 500000, type: 'cash', order: 0, showOnDashboard: true },
    { id: 'wallet-2', name: 'Tài khoản VCB', initialBalance: 10000000, type: 'bank', order: 1, showOnDashboard: true },
];
